# id_porta_com.py
# Descrição: Este script identifica em qual porta COM está conectado o hardware
#            "Silicon Labs CP210x USB to UART Bridge".

import serial.tools.list_ports

def encontrar_porta_do_reader():
    """
    Verifica todas as portas seriais conectadas e procura pelo hardware específico.
    """
    print("🔍  Procurando por hardware 'Silicon Labs CP210x' nas portas COM...")

    # Obtém uma lista de todos os dispositivos de porta serial disponíveis
    portas_disponiveis = serial.tools.list_ports.comports()

    porta_encontrada = None

    for porta in portas_disponiveis:
        # A descrição da porta geralmente contém o nome do driver, como visto no Gerenciador de Dispositivos.
        # Procuramos por 'CP210x', que é a parte principal do nome do seu dispositivo.
        if porta.description and 'CP210x' in porta.description:
            porta_encontrada = porta
            break  # Para a busca assim que encontrar o primeiro dispositivo correspondente

    if porta_encontrada:
        print("\n" + "="*40)
        print("✅  Hardware encontrado!")
        print(f"    - Dispositivo: {porta_encontrada.description}")
        print(f"    - Porta COM: {porta_encontrada.device}")
        print("="*40)
    else:
        print("\n" + "="*40)
        print("❌  Hardware não encontrado.")
        print("    Verifique se o leitor RFID está conectado corretamente ao computador.")
        print("="*40)

if __name__ == "__main__":
    try:
        encontrar_porta_do_reader()
    except Exception as e:
        print(f"\nOcorreu um erro inesperado: {e}")
        print("Certifique-se de que a biblioteca 'pyserial' está instalada.")
        print("Use o comando: pip install pyserial")